{if isset($confirmation)}
    <div class="alert alert-success">{l s='Updated' mod='smsflyorder'}</div>
{/if}

{if isset($test)}
    <div class="alert alert-success">{l s='Test message sent' mod='smsflyorder'}</div>
{/if}

{if isset($balance)}
    <div class="alert alert-success">{l s='Your balance ' mod='smsflyorder'}:{$balance} {$currency}
    </div>
{/if}

<fieldset>
    <div class="panel">
        <div class="panel-heading">
            <legend><img src="../img/admin/cog.gif" alt="" width="16" />{l s='Your details' mod='smsflyorder'}</legend>
        </div>

        <form action="" method="post" id="myForm">

            <div class="form-group clearfix">
                    <label for="sf_apikey" class="col-xs-3 control-label">{l s='Your login' mod='smsflyorder'}:</label>
                    <div class="col-xs-3">  
                        <input class="form-control" type="text" id="sf_apikey" name="sf_apikey" value="{$sf_apikey}" onchange="submitForm()" required>
                        <input type="hidden" name="sf_form_apply" value="1">
                        <script>
                        (function(){
                            function cleanPhoneNumber(phoneNumber) { return (phoneNumber || '').replace(/\D/g, ''); }
                            function toggleSubmitButton() {
                                var inputField = document.getElementById('sf_admin_num');
                                var submitButton = document.getElementsByName('sf_form_balance')[0];
                                if (!submitButton) return;
                                var cleaned = cleanPhoneNumber(inputField ? inputField.value : '');
                                submitButton.disabled = (cleaned === '');
                            }
                            window.toggleSubmitButton = toggleSubmitButton;
                            window.submitForm = function() {
                                var form = document.getElementById('myForm');
                                if (form) form.submit();
                            };
                            if (document.readyState === 'loading') document.addEventListener('DOMContentLoaded', toggleSubmitButton);
                            else toggleSubmitButton();
                        })();
                        </script>
                    </div>
                    <label for="sf_channel" class="col-xs-3 control-label">{l s='Select a channel' mod='smsflyorder'}:</label>
                    <div class="col-xs-3">
                        <select id="sf_channel" name="sf_channel" class="form-control" onchange="submitForm()" required>
                            <option value="sms" {if $sf_channel == 'sms'}selected{/if}>{l s='SMS' mod='smsflyorder'}</option>
                            {if isset($currency) && $currency != 'PLN'}
                                <option value="viber" {if $sf_channel == 'viber'}selected{/if}>{l s='Viber' mod='smsflyorder'}</option>
                                <option value="sms_and_viber" {if $sf_channel == 'sms_and_viber'}selected{/if}>{l s='SMS and Viber' mod='smsflyorder'}</option>
                            {/if}
                        </select>
                    </div>
            </div>

            <div class="form-group clearfix">
                <label for="sf_source" class="col-xs-3 control-label">{l s='Alfaname SMS' mod='smsflyorder'}:</label>
                <div class="col-xs-3">
                    <select id="sf_source" name="sf_source" class="form-control" required>
                        {if $SMS_alfanames|@count > 0}
                            {foreach from=$SMS_alfanames item=SMS_alfaname}
                                <option value="{$SMS_alfaname}" {if $SMS_alfaname == $sf_source}selected{/if}>{$SMS_alfaname}</option>
                            {/foreach}
                        {else}
                            <option value="" disabled>{l s='There are no available values' mod='smsflyorder'}</option>
                        {/if}
                    </select>
                </div>
                <label for="sf_admin_num" class="col-xs-3 control-label">{l s='Admin number' mod='smsflyorder'}:</label>
                <div class="col-xs-3">
                    <input type="text" id="sf_admin_num" name="sf_admin_num" value="{$sf_admin_num}" placeholder="+XX XXX XXX XXXX" onchange="toggleSubmitButton()" required>
                </div>
            </div>

            {if isset($currency) && $currency != 'PLN'}
            <div class="form-group clearfix">
                <label for="sf_source_viber" class="col-xs-3 control-label">{l s='Alfaname Viber' mod='smsflyorder'}:</label>
                <div class="col-xs-3">
                    <select id="sf_source_viber" name="sf_source_viber" class="form-control" required>
                        {if $VIBER_alfanames|@count > 0}
                            {foreach from=$VIBER_alfanames item=VIBER_alfaname}
                                <option value="{$VIBER_alfaname}" {if $VIBER_alfaname == $sf_source_viber}selected{/if}>{$VIBER_alfaname}</option>
                            {/foreach}
                        {else}
                            <option value="" disabled>{l s='There are no available values' mod='smsflyorder'}</option>
                        {/if}
                    </select>
                </div>
            </div>
            {/if}

            <div class="form-group clearfix">
                <div class="panel col-xs-12">
                    <div class="panel-heading">
                        <legend>{l s='Templates for hook: New order' mod='smsflyorder'} <small>(newOrder)</small></legend>
                    </div>
                    <div class="panel-body">
                        <p class="help-block">{$hook_desc_new_order}</p>
                        <div class="form-group col-xs-6">
                            <label for = "sf_utpl">{l s='Users text' mod='smsflyorder'}:</label>
                            <textarea id="sf_utpl" name="sf_utpl" rows="4">{$sf_utpl}</textarea>
                        </div>
                        <div class="form-group  col-xs-6">
                            <label for="sf_atpl">{l s='Admins text' mod='smsflyorder'}:</label>
                            <textarea id="sf_atpl" name="sf_atpl" rows="4">{$sf_atpl}</textarea>
                        </div>
                        <div class="form-group clearfix">
                            <label class="col-xs-3">{l s='Send user' mod='smsflyorder'}:</label>
                            <div class="col-xs-3">
                                <input type="radio" id="sf_user_on_1" name="sf_user_on" value="1" {if $sf_user_on eq '1'}checked{/if}/>
                                <label class="t" for="sf_user_on_1">{l s='Yes' mod='smsflyorder'}</label>
                                <input type="radio" id="sf_user_on_0" name="sf_user_on" value="0" {if empty($sf_user_on) || $sf_user_on eq '0'}checked{/if}/>
                                <label class="t" for="sf_user_on_0">{l s='No' mod='smsflyorder'}</label>
                            </div>
                            <label class="col-xs-3">{l s='Send admin' mod='smsflyorder'}:</label>
                            <div class="col-xs-3">
                                <input type="radio" id="sf_admin_on_1" name="sf_admin_on" value="1" {if $sf_admin_on eq '1'}checked{/if}/>
                                <label class="t" for="sf_admin_on_1">{l s='Yes' mod='smsflyorder'}</label>
                                <input type="radio" id="sf_admin_on_0" name="sf_admin_on" value="0" {if empty($sf_admin_on) || $sf_admin_on eq '0'}checked{/if}/>
                                <label class="t" for="sf_admin_on_0">{l s='No' mod='smsflyorder'}</label>
                            </div>
                        </div>
                    </div>
                    <div class="panel-footer">
                        {$tpl_desc}
                    </div>
                </div>
            </div>

            <div class="form-group clearfix">
                <div class="panel col-xs-12">
                    <div class="panel-heading">
                        <legend>{l s='Templates for hook: Order status update' mod='smsflyorder'} <small>(actionOrderStatusPostUpdate)</small></legend>
                    </div>
                    <div class="panel-body">
                        <p class="help-block">{$hook_desc_status_update}</p>
                        <table class="table table-bordered">
                            <thead>
                                <tr>
                                    <th>{l s='Order status' mod='smsflyorder'}</th>
                                    <th style="width:120px">{l s='Send SMS' mod='smsflyorder'}</th>
                                    <th>{l s='Message template' mod='smsflyorder'}</th>
                                </tr>
                            </thead>
                            <tbody>
                                {foreach from=$order_states item=state}
                                <tr>
                                    <td><strong>{$state.name|escape:'htmlall'}</strong></td>
                                    <td>
                                        <input type="checkbox" name="sf_status_on[{$state.id_order_state|intval}]" value="1" {if isset($status_templates[$state.id_order_state]) && $status_templates[$state.id_order_state].on}checked{/if} />
                                    </td>
                                    <td>
                                        <textarea name="sf_status_tpl[{$state.id_order_state|intval}]" rows="2" class="form-control">{if isset($status_templates[$state.id_order_state])}{$status_templates[$state.id_order_state].tpl|escape:'htmlall':'UTF-8'}{/if}</textarea>
                                    </td>
                                </tr>
                                {/foreach}
                            </tbody>
                        </table>
                        <div class="panel-footer">
                            {$tpl_desc_status}
                        </div>
                    </div>
                </div>
            </div>

            <div class="panel-footer">
                <input class="btn btn-default pull-right" type="submit" name="sf_form_apply" value="{l s='Save changes' mod='smsflyorder'}" />
                <input class="btn btn-default" type="submit" name="sf_form_test" value="{l s='Send test message' mod='smsflyorder'}" />
                <input class="btn btn-default" type="submit" name="sf_form_balance" value="{l s='Check balance' mod='smsflyorder'}" {if empty($sf_admin_num)}disabled{/if} />
                {if isset($logs_link)}<a href="{$logs_link}" class="btn btn-default">{l s='View logs' mod='smsflyorder'}</a>{/if}
            </div>
        </form>
    </div>
</fieldset>
