<div class="log-container">
    <div class="log-header-container">
        <a href="{$module_link}" class="back-link">← {l s='Back to Main Page' mod='smsflyorder'}</a>
        <h2 class="log-header">📋 {l s='Log Entries' mod='smsflyorder'}</h2>
        <p class="log-description">{l s='Review all system logs, including requests and responses.' mod='smsflyorder'}</p>
        {if isset($clear_log_url)}
        <form method="post" action="{$clear_log_url|escape:'html':'UTF-8'}" class="clear-log-form" onsubmit="return confirm('{l s='Clear all log entries?' mod='smsflyorder' js=1}');">
            <input type="hidden" name="sf_clear_logs" value="1" />
            <button type="submit" class="btn btn-default clear-log-btn">{l s='Clear log' mod='smsflyorder'}</button>
        </form>
        {/if}
    </div>
    <table class="log-table">
        <thead>
        <tr>
            <th>{l s='Date' mod='smsflyorder'}</th>
            <th>{l s='Type' mod='smsflyorder'}</th>
            <th>{l s='Token' mod='smsflyorder'}</th>
            <th>{l s='Sender' mod='smsflyorder'}</th>
            <th>{l s='Status' mod='smsflyorder'}</th>
            <th>{l s='Request Details' mod='smsflyorder'}</th>
            <th>{l s='Response Details' mod='smsflyorder'}</th>
        </tr>
        </thead>
        <tbody>
        {if $logs|@count > 0}
        {foreach from=$logs item=log}
            <tr>
                <td>{$log.created_at|escape:'html'}</td>
                <td>{$log.type}</td>
                <td>{$log.token}</td>
                <td>{$log.sender}</td>
                <td>
                    <span class="status-label {if $log.status != 'error'}status-success{else}status-error{/if}">
                        {l s=$log.status mod='smsflyorder'}
                    </span>
                </td>
                <td><button class="log-view-btn" data-log="{$log.request|escape:'html'}">{l s='View' mod='smsflyorder'}</button></td>
                <td><button class="log-view-btn" data-log="{$log.response|escape:'html'}">{l s='View' mod='smsflyorder'}</button></td>
            </tr>
        {/foreach}
        {else}
            <tr>
                <td colspan="6" class="text-center">{l s='No logs available' mod='smsflyorder'}</td>
            </tr>
        {/if}
        </tbody>
    </table>
</div>

<style>
    /* Back link styling */
    .back-link {
        display: inline-block;
        font-size: 16px;
        color: #007bff;
        text-decoration: none;
        margin-bottom: 15px;
        font-weight: bold;
    }

    .back-link:hover {
        color: #0056b3;
        text-decoration: underline;
    }


    /* General container styling */
    .log-container {
        margin: 30px auto;
        padding: 20px;
        background-color: #ffffff;
        border-radius: 8px;
        box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
        max-width: 90%;
    }

    /* Header section */
    .log-header-container {
        margin-bottom: 20px;
        text-align: center;
    }

    .log-header {
        font-size: 28px;
        font-weight: bold;
        margin-bottom: 5px;
        color: #333;
    }

    .log-description {
        font-size: 16px;
        color: #666;
    }

    .clear-log-form {
        margin-top: 12px;
    }

    .clear-log-btn {
        background-color: #dc3545;
        color: #fff;
        border: none;
        padding: 8px 16px;
        border-radius: 5px;
        cursor: pointer;
        font-size: 14px;
    }

    .clear-log-btn:hover {
        background-color: #c82333;
        color: #fff;
    }

    /* Table styling */
    .log-table {
        width: 100%;
        border-collapse: collapse;
        overflow: hidden;
        border-radius: 8px;
    }

    .log-table th, .log-table td {
        padding: 12px;
        text-align: left;
    }

    .log-table th {
        background-color: #f4f5f7;
        font-size: 16px;
        font-weight: bold;
        color: #555;
    }

    .log-table tr:nth-child(odd) {
        background-color: #fafbfc;
    }

    .log-table tr:nth-child(even) {
        background-color: #f9f9f9;
    }

    .log-table tr:hover {
        background-color: #f1f1f1;
    }

    /* Buttons */
    .log-view-btn {
        background-color: #007bff;
        color: #fff;
        border: none;
        padding: 8px 12px;
        cursor: pointer;
        font-size: 14px;
        border-radius: 5px;
        transition: background-color 0.3s ease;
    }

    .log-view-btn:hover {
        background-color: #0056b3;
    }

    /* Status labels */
    .status-label {
        padding: 5px 10px;
        border-radius: 5px;
        font-size: 14px;
        font-weight: bold;
        color: #fff;
        text-transform: uppercase;
    }

    .status-success {
        background-color: #28a745;
    }

    .status-error {
        background-color: #dc3545;
    }
</style>






<style>
    /* Основные стили модального окна */
    .log-modal {
        display: none;
        position: fixed;
        z-index: 1000;
        left: 0;
        top: 0;
        width: 100%;
        height: 100%;
        overflow: auto;
        background-color: rgba(0, 0, 0, 0.6); /* Затемнённый фон */
    }

    /* Контейнер модального окна */
    .log-modal-content {
        background-color: #fff;
        margin: 10% auto;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
        max-width: 700px;
        max-height: 80vh;
        overflow-y: auto;
        color: #333;
        font-family: 'Roboto', sans-serif;
        position: relative;
    }

    /* Заголовок окна */
    .log-modal-header {
        font-size: 20px;
        font-weight: bold;
        margin-bottom: 15px;
        border-bottom: 1px solid #ddd;
        padding-bottom: 10px;
        text-align: center;
        color: #444;
    }

    /* Текст модального окна */
    .log-modal-text {
        font-size: 14px;
        white-space: pre-wrap; /* Сохранение форматирования и перенос строк */
        word-wrap: break-word; /* Перенос длинных слов */
        line-height: 1.5;
        background-color: #f4f5f7;
        padding: 10px;
        border-radius: 4px;
        border: 1px solid #ddd;
        font-family: 'Courier New', monospace;
    }

    /* Кнопка закрытия */
    .log-modal-close {
        position: absolute;
        top: 10px;
        right: 15px;
        font-size: 22px;
        color: #aaa;
        cursor: pointer;
        transition: color 0.3s ease;
    }

    .log-modal-close:hover {
        color: #333;
    }
</style>

<div id="log-modal" class="log-modal">
    <div class="log-modal-content">
        <span class="log-modal-close">&times;</span>
        <div class="log-modal-header">📜 {l s='Log Details' mod='smsflyorder'}</div>
        <pre id="log-modal-text" class="log-modal-text"></pre>
    </div>
</div>












<script>
    document.addEventListener('DOMContentLoaded', function () {
        const modal = document.getElementById('log-modal');
        const modalText = document.getElementById('log-modal-text');
        const closeModal = document.querySelector('.log-modal-close');

        document.querySelectorAll('.log-view-btn').forEach(button => {
            button.addEventListener('click', function () {
                const logData = this.getAttribute('data-log');
                try {
                    modalText.textContent = JSON.stringify(JSON.parse(logData), null, 4); // Форматируем JSON с отступами
                }catch (e){
                    modalText.textContent = logData;
                }
                modal.style.display = 'block';
            });
        });

        closeModal.addEventListener('click', function () {
            modal.style.display = 'none';
        });

        window.addEventListener('click', function (event) {
            if (event.target === modal) {
                modal.style.display = 'none';
            }
        });
    });





</script>